const express = require("express");
const { connection, key } = require("../db");
const bodyparser = require("body-parser");
var app = express();
const HashMap = require("hashmap");
const DIDSearchHMData = new HashMap();
app.use(bodyparser.json());

// Route  : To Search by NPA and NXX
app.get('/searchbynpa', (req, res) => {
    let token = req.headers.authorization || req.headers.token
    if (token !== key) {
        res.send({status: 502, message: "Invalid Session you are trying to access"});
        return false;
    }
    const queryData = req.query;
    console.log("Requested Data for /searchbynpa :: ", queryData);
    let condition = '', message = '';

    if (!queryData.timekey)
        message = "timekey not provided!";
    if (!queryData.iduser)
        message = "Invalid account you are trying to access!";

    if (!queryData.NPA || queryData.NPA == undefined || queryData.NPA == null || !queryData.Qty || queryData.Qty == undefined || queryData.Qty == null)
        message = "All field are required,NPA,Qty";

    if (!message) {
        
        let timekey = queryData.timekey
        let qty=queryData.Qty;
        let msgRtrn =queryData.NPA;

        if (checkVal(queryData.NPA)) condition +="`npa` = '"+queryData.NPA+"'"
        if (checkVal(queryData.NXX)) condition +=" AND `nxx` = '"+queryData.NXX+"'"
        if (queryData.Qty > 500) qty =500;

        // To search DID
        commonSearch(req, res, queryData.iduser,timekey, qty, condition, msgRtrn);
    }
    else {
        res.send({ status: 500, message: message });
    }
});

// Route  : To Serch by State and RateCenter
app.get('/searchbyrate', (req, res) => {
    let token = req.headers.authorization || req.headers.token
    if (token !== key) {
        res.send({status: 502, message: "Invalid Session you are trying to access"});
        return false;
    }
    const queryData = req.query;
    console.log("Requested Data for /searchbyrate :: ", queryData);
    let condition = '', message = '';

    if (!queryData.timekey || queryData.timekey == undefined || queryData.timekey == null)
        message = "timekey not provided!";
    if (!queryData.iduser || queryData.iduser == undefined || queryData.iduser == null)
        message = "Invalid account you are trying to access!";

    if (!queryData.RateCenter || queryData.RateCenter == undefined || queryData.RateCenter == null || !queryData.State || queryData.State == undefined || queryData.State == null || !queryData.Qty || queryData.Qty == undefined || queryData.Qty == null)
        message = "All field are required,RateCenter,State,Qty";

    if (!message) {
        
        let timekey = queryData.timekey;
        let qty=queryData.Qty;
        let msgRtrn =queryData.RateCenter;

        if (checkVal(queryData.State)) condition +="`state` = '"+queryData.State+"'"
        if (checkVal(queryData.RateCenter)) condition +=" AND `ratecenter` = '"+queryData.RateCenter+"'"
        if (queryData.Qty > 500) qty =500;

        // To search DID
        commonSearch(req, res, queryData.iduser,timekey, qty, condition, msgRtrn);
             
    }
    else {
        res.send({ status: 500, message: message });
    }
});

function checkVal(val){
    if(!val || val == undefined || val == null || val == 'undefined' || val == 'null' )
        return false;
    else 
        return val;
}

// To Get Pririty
function getPriority(iduser, callback = () => {}) {
    let qry = "SELECT p.`priority`, u.`username` FROM preference p LEFT JOIN `user` u ON p.idsupplier=u.idaccount WHERE p.idservice=(SELECT idservice FROM `user` WHERE iduser = '" + iduser + "' ) AND p.type='did'";
    console.log("DID Query Load:: ", qry);
    connection.query(qry, function (err, rows) {
        let result;
        if (err) {
            result = {status: 502, message: "Something went wrong with connection"};
            callback(0, result);
        } else if (rows.length > 0) {
            result = {status: 200, message: "Data fetched successfully", data: rows};
            callback(1, result);
        } else {
            result = {status: 401, message: "Invalid account setting, kindly contact Admin", data: []};
            callback(0, result);
        }
    });
}
function commonSearch(req, res, iduser, timekey, qty, condition, msgRtrn){
    getPriority(iduser, function(errPrio, priorityData) {
        if(errPrio == 1 && priorityData.status==200){
            let index_thinq = "100", index_intel = "100";
            priorityData.data.forEach(element => {
                if (element.username == "thinq")
                    index_thinq = element.priority;
                if (element.username == "inteliquent")
                    index_intel = element.priority;
            });
            searchingProvider(index_thinq, timekey, 'thinQ', qty, condition, function(err, result) {
                if (err==1) {
                    searchingProvider(index_intel, timekey, 'inteliQ', qty, condition, function(err1, result) {
                        if (err1==1) {
                            if (DIDSearchHMData.has(timekey.toString())) {
                                let prodata = DIDSearchHMData.get(timekey.toString())
                                let result = getSearchedDID(prodata,qty);
                                DIDSearchHMData.delete(timekey.toString());
                                console.log("DID Data Available::", { status: 200, message: "DID Fetched Successfully"});                                
                                res.send({ status: 200, message: "DID Fetched Successfully", data: result });
                            }
                            else {
                                console.log("DID Data Not Available :: ", { status: 404, message: "No DID's found on [" + msgRtrn + "]" });
                                res.send({ status: 404, message: "No DID's found on [" + msgRtrn + "]" });                                
                            }
                        } else {
                            console.log("Error : thinQ Provider Search :: ", { status: 404, message: "No DID's found on [" + msgRtrn + "]" }); 
                            res.send({ status: 404, message: "No DID's found on [" + msgRtrn + "]" });
                        }
                    });
                }
                else {
                    console.log("Error : inteliQ Provider Search :: ", { status: 404, message: "No DID's found on [" + msgRtrn + "]" }); 
                    res.send({ status: 404, message: "No DID's found on [" + msgRtrn + "]" });
                }
            });
        }
        else{
            console.log("Error : Get Provider :: ", { status: priorityData.status, message: priorityData.message });
            res.send({ status: priorityData.status, message: priorityData.message });
        } 
    });      
}
    
function searchingProvider(priority, timekey, provider, qty, condition, callback) {
    if (priority === 100) 
      return callback(null, '');

    let qry = "SELECT `did` phone_number, `ratecenter` rate_center, state, 0 AS supplier_tier FROM `did_buy` WHERE " + condition + " AND `provider`='"+provider+"' AND `type`='NN' LIMIT " + qty;
    console.log("DID Query",qry);
    
    connection.query(qry, function (err, rows) {
        if (err) {
            callback(null, { status: 500, message: "Query Execution Failed" });
        }
        else {
            if (rows.length > 0) {
                saveHmp(timekey, provider, rows);
                callback(1, { status: 200, message: "DID Fetched Successfully", data: rows });
            } else {
                callback(1, { status: 404, message: "DID Data Does Not Exist!" });
            }
        }
        
    });
}

// To Get Balance
function getWalletBalance(callback) {
    let qry = "SELECT w.idaccount, IF(w.`balance`+w.`credit_limit`>0,1,0) isbalance, w.balance,(w.`balance`+w.`credit_limit`) `totalBalance`, u.`is_deleted` FROM wallet w LEFT JOIN `user` u ON u.idaccount=w.idaccount";
    console.log("DID Query Load:: ", qry);
    connection.query(qry, function (err, rows) {
        if (err) return callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        callback(1, rows);
    });
};

function getRate(req, res, tariff, type, category, callback) {
    let cat;
    switch (category) {
        case 'TF': cat = "toll_free_number"; break;
        case 'NN': cat = "local_number"; break;
        case 'VN': cat = "vanity_number"; break;
        default:
            return "Invalid category";
    }
    let obj1 = new ModelRawQuery(req, res);
    obj1.qrysql = "SELECT `rate` FROM `voice_rates` WHERE `idtariff`='" + tariff + "' AND `category`='" + cat + "' AND `type`='" + type + "' LIMIT 1";
    obj1.prepare();

    obj1.execute(function(err, rates) {
        if (err === 1) {
            let rt = rates.length > 0 ? rates : [{ rate: 0, ...rates[0] }];
            return { status: 200, message: "Rate Found", data: rt };
        } else {
            return { status: 404, message: "Account setting invalid because rate not found" };
        }
    });
}


function saveHmp(timekey, provider, data){
    let existingArray = DIDSearchHMData.get(timekey);
    if (!existingArray) {
        existingArray = []; 
    }
    let key = timekey+'_'+provider;
    let obj = {
    [key]: data
    };
    existingArray.push(obj);
    DIDSearchHMData.set(timekey, existingArray);        
}

function shuffleArray(array){
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]];
    }
    return array;
}
function getSearchedDID(prodata, qty) {
    const allRecords = [];
    for (const obj of prodata) {
        const key = Object.keys(obj)[0];
        const records = obj[key];
        allRecords.push(...records);
    }
    const shuffledRecords = shuffleArray(allRecords);
    const result = shuffledRecords.slice(0, qty);
    return result;
}


app.listen(3004, () => {
    console.log("Server is Connected at Port :: 3004");
}); 